<?php
use Illuminate\Support\Facades\Auth;

function createThumbnail($sourcePath, $destinationPath, $fixedHeight, $quality = 90) {
    // Get image details
    list($originalWidth, $originalHeight, $imageType) = getimagesize($sourcePath);
    // Determine image type and create image resource
    switch ($imageType) {
        case IMAGETYPE_JPEG:
            $sourceImage = imagecreatefromjpeg($sourcePath);
            break;
        case IMAGETYPE_PNG:
            $sourceImage = imagecreatefrompng($sourcePath);
            break;
        case IMAGETYPE_GIF:
            $sourceImage = imagecreatefromgif($sourcePath);
            break;
        default:
            return false; // Unsupported image type
    }
    // Calculate new width to maintain aspect ratio
    $aspectRatio = $originalWidth / $originalHeight;
    $newWidth = $fixedHeight * $aspectRatio;
    // Create a new true-color image for the thumbnail
    $thumbnailImage = imagecreatetruecolor($newWidth, $fixedHeight);
    // Copy and resample the original image to the thumbnail
    imagecopyresampled($thumbnailImage, $sourceImage, 0, 0, 0, 0, $newWidth, $fixedHeight, $originalWidth, $originalHeight);
    // Save the thumbnail based on its type
    switch ($imageType) {
        case IMAGETYPE_JPEG:
            imagejpeg($thumbnailImage, $destinationPath, $quality);
            break;
        case IMAGETYPE_PNG:
            imagepng($thumbnailImage, $destinationPath);
            break;
        case IMAGETYPE_GIF:
            imagegif($thumbnailImage, $destinationPath);
            break;
    }
    // Destroy image resources to free up memory
    imagedestroy($sourceImage);
    imagedestroy($thumbnailImage);
    return true;
}

function isUserAdministrator() {
    //Check if user is administrator
    $user = Auth::user();
    $user_role = DB::table('codelist.user_roles')
    ->select('codelist.user_roles.*')
    ->where('id', $user->role_id)->first();
    return $user_role->name==='user_role_administrator';
}
