<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('codelist.data_formats', function (Blueprint $table) {
            $table->uuid('id')
            ->primary()
            ->default(DB::raw('gen_random_uuid()'))->unique();
            $table->string('name')->unique();
            $table->timestamps();
        });
        DB::table('codelist.data_formats')->insert([
            'name' => 'data_format_technical_report',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        DB::table('codelist.data_formats')->insert([
            'name' => 'data_format_spatial_data',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        DB::table('codelist.data_formats')->insert([
            'name' => 'data_format_data_table',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('codelist.data_formats');
    }
};
