<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('codelist.thematic_categories', function (Blueprint $table) {
            $table->uuid('id')
            ->primary()
            ->default(DB::raw('gen_random_uuid()'))->unique();
            $table->string('name')->unique();
            $table->timestamps();
        });
        DB::table('codelist.thematic_categories')->insert([
            'name' => 'category_thematic_focus',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        DB::table('codelist.thematic_categories')->insert([
            'name' => 'category_thematic_threat',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        DB::table('codelist.thematic_categories')->insert([
            'name' => 'category_thematic_opportunity',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('codelist.thematic_categories');
    }
};
