<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tabular.project_thematics', function (Blueprint $table) {
            $table->uuid('id')
            ->primary()
            ->default(DB::raw('gen_random_uuid()'))->unique();
            $table->uuid('data_licence_id')->nullable();
            $table->foreign('data_licence_id')->references('id')->on('codelist.data_licences')->onDelete('cascade');
            $table->json('collection_method_ids')->nullable();
            $table->json('data_format_ids')->nullable();
            $table->uuid('project_id');
            $table->foreign('project_id')->references('id')->on('tabular.projects')->onDelete('cascade');
            $table->uuid('thematic_id');
            $table->foreign('thematic_id')->references('id')->on('tabular.thematics')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tabular.project_thematics');
    }
};
